//Listing 16.2. Przykad uycia klasy Account z metodami okrelajcymi operatory przecione
#include <iostream>
using namespace std;

class Account { // klasa bazowa hierarchii
protected:
  double balance; // dane chronione
  char *owner;
public:

Account(const char* name, double initBalance) // konstruktor oglny
{ owner = new char[strlen(name)+1]; // przydziel pami na stercie
  if (owner == 0) { cout << "\nBrak pamici\n"; exit(0); }
      strcpy(owner, name); // zainicjalizuj pola danych
      balance = initBalance; }

double getBal() const // metoda wsplna dla obu kont
{ return balance; }

const char* getOwner() const // zabezpiecz dane przed zmian
{ return owner; }

void operator -= (double amount)
{ balance -= amount; } // przeka odpowiedzialnoc wyej

void operator += (double amount)
{ balance += amount; } // bezwarunkowo zwiksz warto
} ;

Account* createAccount(const char* name, double bal)
{ Account* a = new Account(name,bal); // konto na stercie
  if (a == 0) { cout << "\nBrak pamici\n"; exit(0); }
  return a; }

void processRequest(Account* a[], const char name[])
{ int i; int choice; double amount;
  cout.setf(ios::fixed,ios::floatfield);
  cout.precision(2);
  for (i=0; a[i] != 0; i++)
  { if (strcmp(a[i]->getOwner(),name)==0) // odszukaj nazwisko
     { cout << "Stan konta: " << a[i]->getBal() << endl;
     cout <<"Wcinij 1 aby zdeponowa pienidze, 2 aby wypaci, 3 aby zakoczy: ";
     cin >> choice; // rodzaj transakcji
     if (choice != 1 && choice != 2) break;
       cout << "Wprowad kwot: ";
       cin >> amount; // kwota transakcji
       switch (choice) {
         case 1: *a[i] += amount; // a[i]->operator+=(amount);
                  break;
         case 2: if (amount <= a[i]->getBal())
                  *a[i] -= amount; // a[i]->operator-=(amount);
                 else
                  cout << "Niewystarczajca ilo rodkw\n";
                 break; } // koniec zakresu widocznoci instrukcji switch
         cout << "Nowy stan konta: "<< a[i]->getBal() << endl;
     break; } } // koniec ptli przeszukiwania
  if (a[i] == 0)
     { cout << "Klient nie zosta odnaleziony\n"; } }

void printList (Account* a[])
{ cout << "Lista klientw:\n\n";
  for (int i=0; a[i] != 0; i++)
  { cout.setf(ios::left, ios::adjustfield); cout.width(30);
    cout << a[i]->getOwner();
    cout.setf(ios::right, ios::adjustfield); cout.width(10);
    cout << a[i]->getBal() << endl; }
  cout << endl; }

int main()
{
  Account* accounts[100]; char name[80]; // dane programu
  accounts[0] = createAccount("Kowalski",5000); // utwrz obiekty
  accounts[1] = createAccount("Nowak",3000);
  accounts[2] = createAccount("Ochocki",1000);
  accounts[3] = createAccount("Braun",1000);
  accounts[4] = 0;
  printList(accounts);
  while (true) // przetwrz dania
  { cout << "Podaj nazwisko klienta ('exit' w celu zakoczenia pracy): ";
    cin >> name; // pobierz nazwisko
       if (strcmp(name,"exit")==0) break; // sprawdzenie warunku koca
       processRequest(accounts, name); // kolejna transakcja
       }
return 0;
}
